/*************************************************************************
 *
 * Hitchhiker's Guide to the IBM PE 
 * Matrix Inversion Program - Fast serial version
 * Chapter 4 - So Long And Thanks For All The Fish
 *
 * To compile:
 * cc -o inverse_serial_fast inverse_serial_fast.c
 *
 *************************************************************************/


#include<stdlib.h>
#include<stdio.h>
#include<assert.h>
#include<errno.h>

float **partial_determinant(float **matrix,int size);
float determinant(float **matrix,int size, int * used_rows, int * used_cols, int depth,float **pd);
void print_matrix(FILE * fptr,float ** mat,int rows, int cols);
int epsilon(int *,int size);
float coefficient(float **matrix,int size, int row, int col, float **pd);

float test_data[8][8] =  { 
			   {4.0, 2.0, 4.0, 5.0, 4.0, -2.0, 4.0, 5.0}, 
			   {4.0, 2.0, 4.0, 5.0, 3.0, 9.0, 12.0, 1.0 }, 
			   {3.0, 9.0, -13.0, 15.0, 3.0, 9.0, 12.0, 15.0}, 
			   {3.0, 9.0, 12.0, 15.0, 4.0, 2.0, 7.0, 5.0 }, 
			   {2.0, 4.0, -11.0, 10.0, 2.0, 4.0, 11.0, 10.0 },
			   {2.0, 4.0, 11.0, 10.0, 3.0, -5.0, 12.0, 15.0 },
			   {1.0, -2.0, 4.0, 10.0, 3.0, 9.0, -12.0, 15.0 } ,
			   {1.0, 2.0, 4.0, 10.0, 2.0, -4.0, -11.0, 10.0 } ,
};

#define ROWS 8

int main()
{

  float **matrix;
  float **inverse;
  int rows,i,j;
  float determ;
  int * used_rows, * used_cols;
  float** pd;

  rows = ROWS;

  /* Allocate markers to record rows and columns to be skipped */
  /* during determinant calculation                            */
  used_rows = (int *)    malloc(rows*sizeof(*used_rows));
  used_cols = (int *)    malloc(rows*sizeof(*used_cols));

  /* Allocate working copy of matrix and initialize it from static copy */
  matrix  =   (float **) malloc(rows*sizeof(*matrix));
  inverse =   (float **) malloc(rows*sizeof(*inverse));
  for(i=0;i<rows;i++)
    {
      matrix[i] =  (float *) malloc(rows*sizeof(**matrix));
      inverse[i] = (float *) malloc(rows*sizeof(**inverse));
      for(j=0;j<rows;j++)
	matrix[i][j] = test_data[i][j];
    }

  /* Compute and print determinant */
  printf("The determinant of\n\n");
  print_matrix(stdout,matrix,rows,rows);
  pd = partial_determinant(matrix,rows);
  determ=determinant(matrix,rows,used_rows,used_cols,0,pd);
  printf("\nis %f\n",determ);
  fflush(stdout);
  assert(determ!=0);

  for(i=0;i<rows;i++)
    {
      for(j=0;j<rows;j++)
	{
	  inverse[j][i] = coefficient(matrix,rows,i,j,pd)/determ;
	}
    }

  printf("The inverse is\n\n");
  print_matrix(stdout,inverse,rows,rows);

  for(i=0;i<rows;i++)
    free(pd[i]);
  free(pd);

}

float **partial_determinant(float **matrix,int size)
  {
    int col1, col2, row1=(size-2), row2=(size-1);
    int i,j,k;
    float **partial_det;
    
    /* Compute the determinants of all 2x2 matrices created by combinations */
    /* of columns of the bottom 2 rows                                      */

    partial_det = malloc((size-1)*sizeof(*partial_det));
    for(i=0;i<(size-1);i++)
      {
	partial_det[i]=malloc((size-i-1)*sizeof(**partial_det));
	for(j=0;j<(size-i-1);j++)
	  {
	    partial_det[i][j]=
	      matrix[row1][i]*matrix[row2][i+j+1]-matrix[row1][i+j+1]*matrix[row2][i];
	  }
      }
    return partial_det;
  }

float determinant(float **matrix,int size, int * used_rows, int * used_cols, int depth,float **pd)
  {
    int col1, col2, row1, row2;
    int j,k;
    float total=0;
    int sign = 1;
    
    /* Find the first unused row */
    for(row1=0;row1<size;row1++)
      {
	for(k=0;k<depth;k++)
	  {
	    if(row1==used_rows[k]) break;
	  }
	if(k>=depth)  /* this row is not used */
	  break;
      }
    assert(row1<size);

    if(depth==(size-2))
      {
	/* There are only 2 unused rows/columns left */

	/* Find the second unused row */
	for(row2=row1+1;row2<size;row2++)
	  {
	    for(k=0;k<depth;k++)
	      {
		if(row2==used_rows[k]) break;
	      }
	    if(k>=depth)  /* this row is not used */
	      break;
	  }
	assert(row2<size);

	/* Find the first unused column */
	for(col1=0;col1<size;col1++)
	  {
	    for(k=0;k<depth;k++)
	      {
		if(col1==used_cols[k]) break;
	      }
	    if(k>=depth)  /* this column is not used */
	      break;
	  }
	assert(col1<size);

	/* Find the second unused column */
	for(col2=col1+1;col2<size;col2++)
	  {
	    for(k=0;k<depth;k++)
	      {
		if(col2==used_cols[k]) break;
	      }
	    if(k>=depth)  /* this column is not used */
	      break;
	  }
	assert(col2<size);

	return pd[col1][col2-col1-1];
      }

    /* There are more than 2 rows/columns in the matrix being processed  */
    /* Compute the determinant as the sum of the product of each element */
    /* in the first row and the determinant of the matrix with its row   */
    /* and column removed                                                */
    total = 0;

    used_rows[depth] = row1;
    for(col1=0;col1<size;col1++)
      {
	for(k=0;k<depth;k++)
	  {
	    if(col1==used_cols[k]) break;
	  }
	if(k<depth)  /* This column is used */
	  continue;
	used_cols[depth] = col1;
	total += sign*matrix[row1][col1]*determinant(matrix,size,used_rows,used_cols,depth+1,pd);
	sign=(sign==1)?-1:1;
      }
    return total;
	    
  }

void print_matrix(FILE * fptr,float ** mat,int rows, int cols)
{
  int i,j;
  for(i=0;i<rows;i++)
    {
      for(j=0;j<cols;j++)
	{
	  fprintf(fptr,"%10.4f ",mat[i][j]);
	}
      fprintf(fptr,"\n");
    }
}

float coefficient(float **matrix,int size, int row, int col, float **pd)
{
  float coef;
  int * ur, *uc;

  ur = malloc(size*sizeof(matrix));
  uc = malloc(size*sizeof(matrix));
  ur[0]=row;
  uc[0]=col;
  coef = (((row+col)%2)?-1:1)*determinant(matrix,size,ur,uc,1,pd);
  return coef;
}

